# This file is part of EventGhost.
# Copyright (C) 2005 Lars-Peter Voss <bitmonster@eventghost.org>
# Copyright (C) 2010 Gerald Himmelein <ghi@ct.de>
#
# EventGhost is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# EventGhost is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with EventGhost; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

import eg

eg.RegisterPlugin(
    name="PowerDVD 10",
    description="Fuegt Steuerung fuer CyberLink PowerDVD 10 hinzu.",
    kind="program",
    author="Gerald Himmelein, setzt auf BitMonsters Plugin auf",
    version="1.0" + "$LastChangedRevision: 1000 $".split()[1],
    createMacrosOnAdd=True,
)

ACTIONS = [
    ("Play", "Wiedergabe", "Film oder Datei abspielen", "{Return}"),
    ("Pause", "Pause", "Wiedergabe pausieren", "{Space}"),
    ("Stop", "Stop", "Wiedergabe stoppen", "{s}"),
    ("Open", "Laufwerk auswaehlen", "Laufwerk zur Wiedergabe auswaehlen", "{Ctrl+o}"),
    ("Eject", "Auswerfen", "Medium auswerfen", "{Ctrl+e}"),
    ("Close", "Schliessen", "PowerDVD beenden", "{Ctrl+x}"),
    ("ScanForward", "Schneller Vorlauf", "Vorspulen", "{f}"),
    ("ScanBackward", "Schneller Ruecklauf", "Zurueckspulen", "{b}"),
    ("ChapterNext", "Kapitel vor", "Zum naechsten Kapitel springen", "{n}"),
    ("ChapterPrevious", "Kapitel zurueck", "Zum vorangegangenen Kapitel springen", "{p}"),
    ("SkipForward", "Zeitsuche vorwaerts", "Springt x Sekunden nach vorn", "{PageUp}"),
    ("SkipBack", "Zeitsuche rueckwaerts", "Springt x Sekunden zurueck", "{PageDown}"),
    ("MenuList", "Menue-Liste", "Verfuegbare Menues auflisten", "{l}"),
    ("DVDRootMenu", "DVD Hauptmenue", "DVD-Hauptmenue aufrufen", "{j}"),
    ("BDPopupMenu", "BD Popup-Menue", "Blu-ray Popup-Menue aufrufen", "{Ctrl+p}"),
    ("InfoOSD", "Info-Anzeige", "Info-Fenster aufrufen", "{d}"),
    ("Zoom", "Zoom", "Vollbildmodus aktivieren", "{z}"),
    ("AddBookmark", "Lesezeichen hinzufuegen", "Lesezeichen hinzufuegen", "{m}"),
    ("Screenshot", "Screenshot aufnehmen", "DVD-Screenshot machen", "{c}"),
    ("ContextMenu", "Kontextmenue", "Kontextmenue oeffnen (Rechtsklick)", "{Apps}"), 
    ("Cancel", "Abbrechen", "Vorgang abbrechen", "{Esc}"), 
    ("Angle", "Winkel", "DVD-Winkelfunktion", "{a}"),
    ("Subtitle", "Untertitel", "Untertitel aktivieren", "{u}"),
    ("SecondarySubtitle", "Sekundaere Untertitel", "Sekundaere Untertitel aktivieren", "Ctrl+u}"),
    ("SayItAgain", "Say It Again", "Letzten Dialogschnipsel wiederholen", "{w}"),
    ("AudioNext", "Tonspur", "Tonspur wechseln", "{h}"),   
    ("NavigateUp", "Nach oben", "Navigation durch Disc-Menue", "{Up}"),
    ("NavigateDown", "Nach unten", "Navigation durch Disc-Menue", "{Down}"),
    ("NavigateRight", "Nach rechts", "Navigation durch Disc-Menue", "{Right}"),
    ("NavigateLeft", "Nach links", "Navigation durch Disc-Menue", "{Left}"),
    ("NavigateEnter", "OK-Taste", "Navigation OK-Taste", "{Return}"),
    ("VolumeUp", "Lauter", "Lautstaerke erhoehen", "{+}"),
    ("VolumeDown", "Leiser", "Lautstaerke verringern", "{-}"),
    ("VolumeMute", "Stumm", "Ton ausschalten", "{q}"),
    ("Red", "Roter Knopf", "Roter Knopf der Fernbedienung", "{F9}"),
    ("Green", "Gruener Knopf", "Gruener Knopf der Fernbedienung", "{F10}"),
    ("Yellow", "Gelber Knopf", "Gelber Knopf der Fernbedienung", "{F11}"),
    ("Blue", "Blauer Knopf", "Blauer Knopf der Fernbedienung", "{F12}"),
    ("SubtitleOff", "Untertitel aus", "Untertitel ausschalten, schlimmer Hack", "{Apps}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Right}{Return}"),
    ("ClosedCaptionsOn", "Closed Captions ein", "Closed Captions einschalten, schlimmer Hack", "{Apps}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Right}{Return}"),
    ("ClosedCaptionsOff", "Closed Captions aus", "Closed Captions ausschalten, schlimmer Hack","{Apps}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Up}{Right}{Down}{Return}"),
]


gWindowMatcher = eg.WindowMatcher('PowerDVD{*}.exe', 'CyberLink PowerDVD{*}')


class ActionPrototype(eg.ActionBase):

    def __call__(self):
        hwnds = gWindowMatcher()
        if hwnds:
            eg.SendKeys(hwnds[0], self.value)
        else:
            raise self.Exceptions.ProgramNotRunning



class PowerDvd(eg.PluginBase):

    def __init__(self):
        self.AddActionsFromList(ACTIONS, ActionPrototype)

